/*
 * Decompiled with CFR 0.152.
 */
package applets.clickableImage;

import applets.MessageUtilities;
import applets.util.URLEncoder;
import applets.util.WarningDialog;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClickableImageApplet
extends Applet
implements Runnable {
    private static final long serialVersionUID = 1L;
    Image image;
    Vector<Polygon> regions;
    Polygon activeRegion;
    Polygon currentRegion;
    boolean interact;
    String loadingStatus;
    boolean gotImage = false;
    private Frame holderFrame;
    private String baseURL = "";
    private String id;
    private String sessionId = "";
    Locale mtaLocale = new Locale("en", "US");

    private URL completeURL(String tail) throws MalformedURLException {
        try {
            return new URL(URLEncoder.encode(tail));
        }
        catch (Exception e) {
            try {
                return new URL(new URL(this.getParameter("baseURL")), URLEncoder.encode(tail));
            }
            catch (Exception e1) {
                return new URL(this.getDocumentBase(), URLEncoder.encode(tail));
            }
        }
    }

    public void destroy() {
        this.holderFrame.dispose();
    }

    public void dialog(Exception e) {
        this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.ErrorLoadingImage");
        this.showStatus(this.loadingStatus);
        System.out.println("Exception: " + e.toString());
        e.printStackTrace();
        new WarningDialog(this.holderFrame, String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingClickableImage.Error.Part1")) + "\n \n" + "   " + this.getParameter("imageURL") + "\n \n" + MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingClickableImage.Error.Part2"), this.mtaLocale).setVisible(true);
    }

    public void drawActiveRegion(Graphics g, Polygon p) {
        if (p == null || p.npoints == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setPaintMode();
        g2d.setColor(Color.green);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawPolygon(p);
        g2d.setColor(new Color(0.1f, 0.1f, 0.1f, 0.6f));
        g2d.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void drawPassiveRegion(Graphics g, Polygon p) {
        if (p == null || p.npoints == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setPaintMode();
        g2d.setColor(new Color(0.9f, 0.5f, 0.02f));
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawPolygon(p);
        g2d.setColor(new Color(0.6f, 0.6f, 0.6f, 0.6f));
        g2d.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    private void drawThickLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x1 + 1, y1, x2 + 1, y2);
        g.drawLine(x1, y1 + 1, x2, y2 + 1);
    }

    public Polygon findRegion(int x, int y) {
        int i = 0;
        while (i < this.regions.size()) {
            Polygon p = this.regions.elementAt(i);
            if (p.contains(x, y)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public void init() {
        String[] locale;
        try {
            locale = this.getParameter("mtalocale").split("_");
        }
        catch (Exception e) {
            locale = "en_US".split("_");
        }
        if (locale.length == 1) {
            this.mtaLocale = new Locale(locale[0]);
        } else if (locale.length == 2) {
            this.mtaLocale = new Locale(locale[0], locale[1]);
        } else if (locale.length == 3) {
            this.mtaLocale = new Locale(locale[0], locale[1], locale[2]);
        }
        this.id = this.getParameter("id");
        this.sessionId = this.getParameter("sessionId");
        this.holderFrame = new Frame();
        try {
            String activeStr;
            String region;
            this.setBackground(Color.white);
            new Thread(this).start();
            this.regions = new Vector();
            int i = 1;
            while ((region = this.getParameter("region." + i)) != null) {
                StringTokenizer stz = new StringTokenizer(region, ",\n\t ");
                int numPoints = stz.countTokens() / 2;
                Polygon p = new Polygon();
                int j = 0;
                while (j < numPoints) {
                    p.addPoint(Integer.parseInt(stz.nextToken()), Integer.parseInt(stz.nextToken()));
                    ++j;
                }
                this.regions.addElement(p);
                ++i;
            }
            this.interact = "select".equals(this.getParameter("mode"));
            if (!this.interact) {
                this.activeRegion = this.regions.elementAt(0);
            }
            if ((activeStr = this.getParameter("active")) != null) {
                try {
                    int comma = activeStr.indexOf(44);
                    int x = Integer.parseInt(activeStr.substring(0, comma));
                    int y = Integer.parseInt(activeStr.substring(comma + 1));
                    this.activeRegion = this.findRegion(x, y);
                    this.sendClick(x, y);
                }
                catch (Exception e) {
                    this.activeRegion = null;
                }
            }
        }
        catch (Exception e) {
            this.dialog(e);
        }
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        return this.mouseMove(evt, x, y);
    }

    public boolean mouseEnter(Event event, int x, int y) {
        this.showStatus(this.loadingStatus);
        return true;
    }

    public boolean mouseMove(Event evt, int x, int y) {
        if (!this.interact || !this.gotImage) {
            return true;
        }
        Polygon p = this.currentRegion;
        if (this.currentRegion == null || !this.currentRegion.contains(x, y)) {
            this.currentRegion = this.findRegion(x, y);
        }
        if (p != this.currentRegion) {
            this.update(this.getGraphics());
        }
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (!this.interact || !this.gotImage) {
            return true;
        }
        if (this.currentRegion != null) {
            this.activeRegion = this.currentRegion;
            this.sendClick(x, y);
            this.update(this.getGraphics());
        }
        return true;
    }

    public void paint(Graphics g) {
        if (this.gotImage) {
            super.paint(g);
            g.drawImage(this.image, 0, 0, this);
        } else {
            g.drawString(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.LoadingImage"), 4, 34);
        }
        this.drawPassiveRegion(g, this.currentRegion);
        this.drawActiveRegion(g, this.activeRegion);
    }

    public void run() {
        try {
            this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.LoadingImage");
            this.showStatus(this.loadingStatus);
            MediaTracker tracker = new MediaTracker(this);
            this.image = this.getImage(this.completeURL(this.getParameter("imageURL")));
            tracker.addImage(this.image, 0);
            while (tracker.statusID(0, true) == 1) {
                this.showStatus(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.LoadingImage"));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.showStatus("");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (tracker.isErrorID(0)) {
                throw new Exception(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.ErrorLoadingImage"));
            }
            Image tempImage = this.createImage(this.image.getWidth(this), this.image.getHeight(this));
            tempImage.getGraphics().drawImage(this.image, 0, 0, Color.white, this);
            this.image = tempImage;
            this.gotImage = true;
            this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.MakeSelection");
            this.showStatus(this.loadingStatus);
            this.repaint();
        }
        catch (Exception e) {
            this.dialog(e);
        }
    }

    private void sendClick(int x, int y) {
        this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.RecordingSelection");
        this.showStatus(this.loadingStatus);
        String urlStr = String.valueOf(this.getBaseURL()) + "modules/util.PersistResponse?slash=/" + "&" + "clickable.image.response" + "=" + this.getParameter("clickable.image.response") + "&response=" + x + "," + y + "&id=" + this.id;
        try {
            HttpURLConnection connection = (HttpURLConnection)this.completeURL(urlStr).openConnection();
            connection.addRequestProperty("Cookie", "JSESSIONID=" + this.sessionId);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = in.readLine();
            in.close();
            if ("OK".equals(line)) {
                this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.SelectionRecorded");
                this.showStatus(this.loadingStatus);
            } else {
                this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.UnexpectedServerResponse");
                this.showStatus(this.loadingStatus);
            }
            return;
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.toString());
            e.printStackTrace();
            this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageApplet.LoadingStatus.SelectionNotRecorded");
            this.showStatus(this.loadingStatus);
            this.activeRegion = null;
            return;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private String getBaseURL() {
        if (this.baseURL == null || this.baseURL.trim().length() == 0) {
            this.baseURL = this.getParameter("baseURL");
        }
        return this.baseURL;
    }
}

