/*
 * Decompiled with CFR 0.152.
 */
package applets.proctoredTest;

import applets.MessageUtilities;
import applets.util.WarningDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JLabel;

public class Timer
extends JApplet
implements Runnable {
    private static final long serialVersionUID = 845228335797500677L;
    Locale mtaLocale = new Locale("en", "US");
    private long remainingTime;
    Frame holderFrame = new Frame();
    private String displayCountdown = "";
    private JLabel theLabel1 = new JLabel("", 4);
    private JLabel theLabel2 = new JLabel("", 4);
    private boolean timeToDie;

    public void destroy() {
        System.out.println("-- destroy() was called.");
        this.timeToDie = true;
        this.holderFrame.dispose();
        this.holderFrame = null;
    }

    public void init() {
        String[] locale;
        try {
            locale = this.getParameter("mtalocale").split("_");
        }
        catch (Exception e) {
            locale = "en_US".split("_");
        }
        if (locale.length == 1) {
            this.mtaLocale = new Locale(locale[0]);
        } else if (locale.length == 2) {
            this.mtaLocale = new Locale(locale[0], locale[1]);
        } else if (locale.length == 3) {
            this.mtaLocale = new Locale(locale[0], locale[1], locale[2]);
        }
        this.remainingTime = Long.parseLong(this.getParameter("remainingTime"));
        this.setBackground(Color.white);
        this.setForeground(new Color(29, 54, 104));
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 10));
        this.theLabel1.setOpaque(true);
        this.theLabel2.setOpaque(true);
        this.theLabel1.setBackground(Color.white);
        this.theLabel2.setBackground(Color.white);
        if (this.remainingTime < 300L) {
            this.theLabel2.setForeground(new Color(119, 0, 0));
        }
        String displayCountdownLabel = MessageUtilities.getMessage(this.mtaLocale, "Common.RemainingTime.Label");
        this.theLabel1.setText(displayCountdownLabel);
        this.add((Component)this.theLabel1, "Center");
        this.add((Component)this.theLabel2, "East");
        this.timeToDie = false;
        new Thread(this).start();
    }

    private int getSeconds(long time) {
        int secNum = (int)(time % 3600L) % 60;
        return secNum;
    }

    private int getMinutes(long time) {
        int minNum = (int)(time % 3600L) / 60;
        return minNum;
    }

    private int getHours(long time) {
        int hourNum = (int)(time / 3600L);
        return hourNum;
    }

    public void run() {
        String fiveMinutesMessage = MessageUtilities.getMessage(this.mtaLocale, "Timer.FiveMinutesMessage");
        String expiredMessage = MessageUtilities.getMessage(this.mtaLocale, "Timer.ExpiredMessage");
        while (!this.timeToDie) {
            int hours = this.getHours(this.remainingTime);
            int mins = this.getMinutes(this.remainingTime);
            int secs = this.getSeconds(this.remainingTime);
            Formatter formatter = new Formatter();
            this.displayCountdown = formatter.format(" %1$02d:%2$02d:%3$02d", hours, mins, secs).toString();
            this.theLabel2.setText(this.displayCountdown);
            this.repaint();
            if (this.remainingTime == 300L) {
                new WarningDialog(this.holderFrame, fiveMinutesMessage, this.mtaLocale).setVisible(true);
                this.theLabel2.setForeground(new Color(119, 0, 0));
            } else if (this.remainingTime == 0L) {
                new WarningDialog(this.holderFrame, expiredMessage, this.mtaLocale).setVisible(true);
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("-- run() was interrupted.");
                break;
            }
            --this.remainingTime;
        }
        System.out.println("-- Exiting from run().");
    }
}

