<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@page import="com.maplesoft.mapleta.session.Context"%>

<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<tiles:useAttribute name="question"/>
<tiles:useAttribute name="view"/>
<tiles:useAttribute name="qCount"/>
<tiles:useAttribute name="inherited"/>
<tiles:useAttribute name="assignments"/>

<c:set var="classDTO" value="<%= Context.getContext(request.getSession()).getClassDTO() %>"/>
<c:set var="shadow">false</c:set>
<c:if test="${question.author.id != classDTO.id && view == 'Private'}">
	<c:set var="shadow">true</c:set>
</c:if>

<script src="<%=request.getContextPath()%>/modules/scripts/repository.js"></script>
<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/modules/skin/css/repository.css">

<fmt:bundle	basename="com.maplesoft.mapleta.application.ApplicationResources">


<table cellpadding="0" cellspacing="2">
	<tr>	
	<c:if test="${view != 'Revision'}">
		<td class="check" rowspan="2">
			<html:multibox property="questions" styleId="qcb${question.id}" onclick="checkSelectAll();">${question.id}</html:multibox>
		</td>
	</c:if>
		<td class="padleft question color" rowspan="2" colspan="5">

			<label for="qcb${question.id}">
				<span class="question_name <c:if test='${not question.questionPrivate}'>public</c:if> <c:if test='${shadow}'>shadow</c:if>">
					<c:out value="${question.name}" escapeXml="false"/>
				</span>
			</label>
		</td>
		
		<td class="preview " colspan="2">
			<a class="questionLink" href="javascript:displayQuestion(${question.id})"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/preview.gif" title="<fmt:message key='QuestionRepositoryActionForm.preview.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.preview.title'/>"/>
			</a>
	<c:if test="${question.author.id == classDTO.id}">
			<a class="questionLink" href="<%= request.getContextPath() %>/modules/dbEdit.Display?id=${question.id}"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/edit.gif" title="<fmt:message key='QuestionRepositoryActionForm.edit.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.edit.title'/>"/>
			</a>
	</c:if>
	<c:if test="${view != 'Revision'}">
			<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/ModifyQuestionGroups.do?id=${question.id}"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/modify_groups.gif" title="<fmt:message key='QuestionRepositoryActionForm.modify.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.modify.title'/>"/>
			</a>
	</c:if>
			<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=clone"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/clone.gif" title="<fmt:message key='QuestionRepositoryActionForm.clone.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.clone.title'/>"/>
			</a>
	<c:if test="${view == 'Private' && not shadow}">
		<c:choose>
			<c:when test="${question.deleted}">
			<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=undelete"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/undelete.gif" title="<fmt:message key='QuestionRepositoryActionForm.undelete.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.undelete.title'/>"/>
			</a>
			</c:when>
			<c:when test="${question.questionPrivate}">
			<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=delete"/>
				<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/delete.gif" title="<fmt:message key='QuestionRepositoryActionForm.delete.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.delete.title'/>"/>
			</a>
			</c:when>
		</c:choose>
	</c:if>
	<c:if test="${view == 'Private' && not shadow && not question.deleted}">
		<c:choose>
			<c:when test="${question.questionPrivate}">
				<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=make_public"/>
					<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/public.gif" title="<fmt:message key='QuestionRepositoryActionForm.makePublic.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.makePublic.title'/>"/>
				</a>
			</c:when>
			<c:otherwise>
				<a class="questionLink" href="<%= request.getContextPath() %>/qbeditor/SelectQuestions.do?questions=${question.id}&dispatch=make_private"/>
					<img class="questionLink" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/private.gif" title="<fmt:message key='QuestionRepositoryActionForm.makePrivate.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.makePrivate.title'/>"/>
				</a>
			</c:otherwise>
		</c:choose>
	
	
	</c:if>

	<c:if test="${view == 'Private' && not shadow && fn:length(question.revisions)>0 }">
			<a href="<%= request.getContextPath() %>/qbeditor/Revisions.do?id=${question.id}"><fmt:message key="QuestionRepositoryActionForm.revisions.label"/> (${fn:length(question.revisions)})</a>
	</c:if>

		</td>
	<tr class="">
		<td class="label"><fmt:message key="QuestionRepositoryActionForm.author.label"/>:</td><td class="info">${question.author.name}</td>
	<tr>

	<tr class="" id="questionDetail${qCount}">
		<c:if test="${view != 'Revision'}">
			<td class="check" rowspan="1" align="center">
			<c:choose>
				<c:when test="${question.deleted}">
					<img src="<%=request.getContextPath()%>/modules/dbEdit/images/deleteQuestion.gif" width="13" height="13">
				</c:when>
				<c:when test="${shadow}">
					<img src="<%=request.getContextPath()%>/modules/configureTest/images/shared.gif" width="13" height="13">
				</c:when>
				<c:otherwise>&nbsp;</c:otherwise>
			</c:choose>
			</td>
		</c:if>
		<td class="label">&nbsp;<fmt:message key="QuestionRepositoryActionForm.created.label"/>:</td>
		<td class="date"><fmt:formatDate value="${question.created}" dateStyle="short" type="date"/> <fmt:formatDate value="${question.created}" timeStyle="short" type="time"/></td>
		<td class="label"><fmt:message key="QuestionRepositoryActionForm.modified.label"/>:</td>
		<td class="date"><fmt:formatDate value="${question.lastModified}" dateStyle="short" type="date"/> <fmt:formatDate value="${question.lastModified}" timeStyle="short" type="time"/></td>
		<td width="85px" align="center">
			<c:choose>
			<c:when test="${not empty question.comment}">
				<img src="<%=request.getContextPath()%>/modules/dbEdit/images/hasComment.gif" width="13" height="13">
			</c:when>
			<c:otherwise><img src="<%=request.getContextPath()%>/modules/dbEdit/images/empty.gif" width="13" height="13"></c:otherwise>
			</c:choose>
			<c:choose>
			<c:when test="${not empty question.hint}">
				<img src="<%=request.getContextPath()%>/modules/dbEdit/images/hasHints.gif" width="13" height="13">
			</c:when>
			<c:otherwise><img src="<%=request.getContextPath()%>/modules/dbEdit/images/empty.gif" width="13" height="13"></c:otherwise>
			</c:choose>
			<c:choose>
			<c:when test="${not empty question.algorithm}">
				<img src="<%=request.getContextPath()%>/modules/dbEdit/images/hasAlgorithm.gif" width="13" height="13">
			</c:when>
			<c:otherwise><img src="<%=request.getContextPath()%>/modules/dbEdit/images/empty.gif" width="13" height="13"></c:otherwise>
			</c:choose>
			<c:choose>
			<c:when test="${not empty question.solution}">
				<img src="<%=request.getContextPath()%>/modules/dbEdit/images/hasSolution.gif" width="13" height="13">
			</c:when>
			<c:otherwise><img src="<%=request.getContextPath()%>/modules/dbEdit/images/empty.gif" width="13" height="13"></c:otherwise>
			</c:choose>
		</td>

		<td class="label"><fmt:message key="QuestionRepositoryActionForm.modeDescription.label"/>:</td>
		<td class="mode">
	<a href="<%= request.getContextPath() %>/qbeditor/Questions.do?modes=${question.modeDescription}&searchBy=search.mode" title="${question.mode}">${question.modeDescription}</a>	
		</td>
	</tr>
	
<c:if test="${view == 'Private'}">
	<tr class="hidden" id="questionGroups${qCount}">
		<td class="check">&nbsp;</td>
		<td class="groups color" colspan="7" rowspan="1">
		&nbsp;<strong><fmt:message key="QuestionRepositoryActionForm.groups.label"/>:</strong>
			<c:set var="count" value="0"/>
			<c:forEach var="group" items="${question.groups}">
				<c:choose>
				<c:when test="${inherited}">
					<c:if test="${count != 0}">|</c:if>
					&nbsp;<a href="<%= request.getContextPath() %>/qbeditor/Questions.do?groups=${group.id}&searchBy=search.groups">${group.name}</a>&nbsp;
					<c:set var="count">${count+1}</c:set>
				</c:when>
				</c:choose>
			</c:forEach>
		</td>
		
	</tr>
</c:if>


<c:if test="${view == 'Private'}">
	<tr class="hidden" id="questionAssignments${qCount}">
		<td class="check">&nbsp;</td>
		<td class="groups color" colspan="7" rowspan="1" style="">
		&nbsp;<strong><fmt:message key="QuestionRepositoryActionForm.assignments.label"/>:</strong>
			<c:set var="count" value="0"/>
			<c:forEach var="assignment" items="${assignments}">
				<c:if test="${count != 0}">|</c:if>
			<span style="display: inline-block">
				&nbsp;
				<a href="javascript:assignmentSummary(0, ${assignment.id})">
	<img class="questionLink" style="display:inline;" src="<%=request.getContextPath()%>/modules/dbEdit/repository/images/preview.gif" title="<fmt:message key='QuestionRepositoryActionForm.preview.title'/>" alt="<fmt:message key='QuestionRepositoryActionForm.preview.title'/>"/>				
				</a>
				<a href="<%= request.getContextPath() %>/qbeditor/Questions.do?assignments=${assignment.id}&searchBy=search.assignment">${assignment.name}</a>
				&nbsp;
			</span>
				<c:set var="count">${count+1}</c:set>
			</c:forEach>
		</td>
		
	</tr>
</c:if>


<c:if test="${view == 'Revision'}">
	<tr>
		<td class="padleft groups color" colspan="7" rowspan="1">
		<c:if test="${question.deleted}">
			<img src="<%=request.getContextPath()%>/modules/dbEdit/images/deleteQuestion.gif" width="13" height="13">
		</c:if>
		
			<strong><fmt:message key="QuestionRepositoryActionForm.revision.notes.label"/>:</strong> ${question.annotation} 
		</td>	
	</tr>
</c:if>

	
</table>


</fmt:bundle>
