<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<jsp:directive.page import="com.maplesoft.mapleta.session.Role" />

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<c:set var="unset">
		<%=Role.UNSET%>
	</c:set>

	<tiles:importAttribute name="roles" />
	<tiles:importAttribute name="default_role" />
	<tiles:importAttribute name="allow_unset_role" />

	<%-- if the bean has no selected role, use the default as override--%>
	<c:if test="${allow_unset_role eq 'false' && UserSearch.role == unset}">
		<c:set target="${UserSearch}" property="role" value="${default_role}" />
	</c:if>
	<c:if test="${empty UserSearch.role}">
		<c:set target="${UserSearch}" property="role" value="${default_role}" />
	</c:if>

	<table>
		<tr>
			<td width="120px">
				<strong> <fmt:message
						key="ClassManagerSearchForm.role.label" /> </strong>
			</td>
			<td>
				<logic:iterate id="row" name="roles">
					<c:if test="${allow_unset_role eq 'false' && row.value == unset }"
						var="skip">
					</c:if>
					<c:if test="${!skip}">
						<html:radio property="role" value="value" idName="row" />
						<bean:write name="row" property="label" />
					</c:if>
				</logic:iterate>
			</td>
		</tr>
	</table>

</fmt:bundle>
